% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{CIAdata}
\alias{CIAdata}
\title{Return a dataset based on the CIA World Factbook}
\usage{
CIAdata(name = NULL)
}
\arguments{
\item{name}{An optional parameter specifying the name of the desired dataset.
If multiple names are given, a merge will be attempted on the individual data
sets.}
}
\description{
This function can be used in two different ways. Without an argument, it returns a reference
table that includes information about all the CIA World Factbook tables that are available
through this function. Note the  \code{Name} column that indicates a unique name for each
available dataset. If this name is passed as an argument to the function, the function
will return the corresponding dataset.
}
\examples{
\dontrun{
head(CIAdata())
Population <- CIAdata("pop")
nrow(Population)
head(Population)

PopArea <- 
  CIAdata(c("pop","area")) \%>\% 
  mutate(density = pop / area)
nrow(PopArea)
head(PopArea)
PopArea \%>\% 
  filter(!is.na(density)) \%>\%
  arrange(density) \%>\% 
  tail()
}
}
