% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msummary.R
\name{print.msummary.lm}
\alias{print.msummary.lm}
\alias{print.msummary.glm}
\alias{msummary}
\alias{msummary.default}
\alias{msummary.lm}
\alias{msummary.glm}
\title{Modified summaries}
\usage{
\method{print}{msummary.lm}(x, digits = max(3L, getOption("digits") - 3L),
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"), ...)

\method{print}{msummary.glm}(x, digits = max(3L, getOption("digits") - 3L),
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"), ...)

msummary(object, ...)

\method{msummary}{default}(object, ...)

\method{msummary}{lm}(object, ...)

\method{msummary}{glm}(object, ...)
}
\arguments{
\item{x}{an object to summarize}

\item{digits}{desired number of digits to display}

\item{symbolic.cor}{see \code{\link[=summary]{summary()}}}

\item{signif.stars}{a logical indicating whether to diplay stars to
indicate significance}

\item{...}{aditional arguments}

\item{object}{an object to summarise}
}
\description{
\code{msummary} provides modified summary objects that typically produce
output that is either identical to or somewhat terser than their
\code{\link[=summary]{summary()}} analogs.  The contents of the object itself are unchanged
(except for an augmented class) so that other downstream functions should work as
before.
}
\examples{
msummary(lm(Sepal.Length ~ Species, data = iris))

}
