% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimated_ancestral_va.R
\docType{data}
\name{estimated_ancestral_va}
\alias{estimated_ancestral_va}
\title{Estimated Generalized Procrustes Analysis (GPA) coordinates of ventral anchors of root ancestor}
\format{A matrix of 11 rows (landmarks) and 2 columns (xy-coordinates) representing the
estimated GPA landmark configuration of the ventral anchors of the root ancestor (left and right anchors averaged).}
\source{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.
}
\usage{
data(estimated_ancestral_va)
}
\description{
Estimated GPA landmark configuration of the ventral anchors of the root ancestor of 13 \emph{Ligophorus} species.
}
\details{
The root ancestor's GPA landmark configuration is unknown, but can be estimated using
similar data from extant species. The estimation is done using \code{fastAnc} function in the
\code{phytools} package (Revell, 2012). Root ancestor mean GPA coordinates of anchor landmarks are required for
shape evolution analysis.
}
\examples{
library(gplots)
library(circular)

data(va_mean)
data(estimated_ancestral_va)
data(spcolmap)

cladeII <- spcolmap$species[spcolmap$host \%in\% "L.subviridis"]
shapeEvo(va_mean, estimated_ancestral_va, col.lab="dodgerblue",
clade=cladeII, exfac=2, tit="Ventral anchors")

#Some journals want the title to be left-adjusted, so set tit="" and then:
#title("a)", adj=0)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Revell LJ. (2012). phytools: An R package for phylogenetic comparative biology (and other things).
Methods in Ecology and Evolution 3:217-223.
}
\seealso{
\code{\link{shapeEvo}}
}
\keyword{datasets}

