% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w2n.R
\name{w2n}
\alias{w2n}
\title{Scaling function: working to natural parameters}
\usage{
w2n(
  wpar,
  bounds,
  parSize,
  nbStates,
  nbCovs,
  estAngleMean,
  circularAngleMean,
  consensus,
  stationary,
  cons,
  fullDM,
  DMind,
  workcons,
  nbObs,
  dist,
  Bndind,
  nc,
  meanind,
  covsDelta,
  workBounds,
  covsPi
)
}
\arguments{
\item{wpar}{Vector of working parameters.}

\item{bounds}{Named list of 2-column matrices specifying bounds on the natural (i.e, real) scale of the probability 
distribution parameters for each data stream.}

\item{parSize}{Named list indicating the number of natural parameters of the data stream probability distributions}

\item{nbStates}{The number of states of the HMM.}

\item{nbCovs}{The number of beta covariates.}

\item{estAngleMean}{Named list indicating whether or not to estimate the angle mean for data streams with angular 
distributions ('vm' and 'wrpcauchy').}

\item{circularAngleMean}{Named list indicating whether to use circular-linear or circular-circular
regression on the mean of circular distributions ('vm' and 'wrpcauchy') for turning angles. See \code{\link{fitHMM}}.}

\item{consensus}{Named list indicating whether to use the circular-circular regression consensus model}

\item{stationary}{\code{FALSE} if there are time-varying covariates in \code{formula} or any covariates in \code{formulaDelta}. If \code{TRUE}, the initial distribution is considered
equal to the stationary distribution. Default: \code{FALSE}.}

\item{cons}{Named list of vectors specifying a power to raise parameters corresponding to each column of the design matrix 
for each data stream.}

\item{fullDM}{Named list containing the full (i.e. not shorthand) design matrix for each data stream.}

\item{DMind}{Named list indicating whether \code{fullDM} includes individual- and/or temporal-covariates for each data stream
specifies (-1,1) bounds for the concentration parameters instead of the default [0,1) bounds.}

\item{workcons}{Named list of vectors specifying constants to add to the regression coefficients on the working scale for 
each data stream.}

\item{nbObs}{Number of observations in the data.}

\item{dist}{Named list indicating the probability distributions of the data streams.}

\item{Bndind}{Named list indicating whether \code{DM} is NULL with default parameter bounds for each data stream.}

\item{nc}{indicator for zeros in fullDM}

\item{meanind}{index for circular-circular regression mean angles with at least one non-zero entry in fullDM}

\item{covsDelta}{data frame containing the delta model covariates}

\item{workBounds}{named list of 2-column matrices specifying bounds on the working scale of the probability distribution, transition probability, and initial distribution parameters}

\item{covsPi}{data frame containing the pi model covariates}
}
\value{
A list of:
\item{...}{Matrices containing the natural parameters for each data stream (e.g., 'step', 'angle', etc.)}
\item{beta}{Matrix of regression coefficients of the transition probabilities}
\item{delta}{Initial distribution}
}
\description{
Scales each parameter from the set of real numbers, back to its natural interval.
Used during the optimization of the log-likelihood.
}
\examples{
\dontrun{
m<-example$m
nbStates <- 2
nbCovs <- 2
parSize <- list(step=2,angle=2)
par <- list(step=c(t(m$mle$step)),angle=c(t(m$mle$angle)))
bounds <- m$conditions$bounds
beta <- matrix(rnorm(6),ncol=2,nrow=3)
delta <- c(0.6,0.4)

#working parameters
wpar <- momentuHMM:::n2w(par,bounds,list(beta=beta),log(delta[-1]/delta[1]),nbStates,
m$conditions$estAngleMean,NULL,m$conditions$cons,m$conditions$workcons,m$conditions$Bndind,
m$conditions$dist)

#natural parameter
p <-   momentuHMM:::w2n(wpar,bounds,parSize,nbStates,nbCovs,m$conditions$estAngleMean,
m$conditions$circularAngleMean,lapply(m$conditions$dist,function(x) x=="vmConsensus"),
m$conditions$stationary,m$conditions$cons,m$conditions$fullDM,
m$conditions$DMind,m$conditions$workcons,1,m$conditions$dist,m$conditions$Bndind,
matrix(1,nrow=length(unique(m$data$ID)),ncol=1),covsDelta=m$covsDelta,
workBounds=m$conditions$workBounds)
}


}
