% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary.R
\name{stationary}
\alias{stationary}
\title{Stationary state probabilities}
\usage{
stationary(model, covs)
}
\arguments{
\item{model}{\code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object}

\item{covs}{Either a data frame or a design matrix of covariates. If \code{covs} is not provided, then the stationary probabilties are calculated based on the covariate data for each time step.}
}
\value{
Matrix of stationary state probabilities. Each row corresponds to
a row of covs, and each column corresponds to a state.
}
\description{
Calculates the stationary probabilities of each state based on
covariate values.
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

# data frame of covariates
stationary(m, covs = data.frame(cov1 = 0, cov2 = 0))

# design matrix (each column corresponds to row of m$mle$beta)
stationary(m, covs = matrix(c(1,0,cos(0)),1,3))

}
