% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amodule.R
\name{amodule}
\alias{amodule}
\title{Define Augmented and Parameterized Modules}
\usage{
amodule(expr = {
}, envir = parent.frame(), enclos = baseenv(), class = NULL)
}
\arguments{
\item{expr}{(expression) a module declaration, same as \link{module}}

\item{envir}{(environment) environment used to detect 'parameters'}

\item{enclos}{(environment) the top enclosing environment of the module
scope.}

\item{class}{(character) the module can have a class attribute for
consistency. If you rely on S3 dispatch, e.g. to override the default print
method, you should set this value explicitly.}
}
\description{
\code{amodule} is a wrapper around \link{module} and changes the default
environment to which the module connects. In contrast to \code{module}
the top enclosing environment here is always \code{baseenv}. The second
important difference is that the environment in which a module is created has
meaning: all objects are made available to the module scope. This is
what is meant by \emph{augmented} or \emph{parameterized}. Best practice for
the use of this behavior is to return these modules from functions.
}
\examples{
Constructor <- function(dependency) {
  amodule({
    fun <- function(...) dependency(...)
  })
}
instance <- Constructor(identity)
instance$fun(1)

}
