% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_partable.R
\name{summarize_partable}
\alias{summarize_partable}
\title{Summarize a parameter table from a \code{modsem} model.}
\usage{
summarize_partable(
  parTable,
  scientific = FALSE,
  ci = FALSE,
  digits = 3,
  loadings = TRUE,
  regressions = TRUE,
  covariances = TRUE,
  intercepts = TRUE,
  variances = TRUE
)
}
\arguments{
\item{parTable}{A parameter table, typically obtained from a \code{\link{modsem}} model 
using \code{\link{parameter_estimates}} or \code{\link{standardized_estimates}}.}

\item{scientific}{Logical, whether to print p-values in scientific notation.}

\item{ci}{Logical, whether to include confidence intervals in the output.}

\item{digits}{Integer, number of digits to round the estimates to
(default is 3).}

\item{loadings}{Logical, whether to include factor loadings in the output.}

\item{regressions}{Logical, whether to include regression coefficients in the output.}

\item{covariances}{Logical, whether to include covariance estimates in the output.}

\item{intercepts}{Logical, whether to include intercepts in the output.}

\item{variances}{Logical, whether to include variance estimates in the output.}
}
\value{
A summary object containing the parameter table and additional information.
}
\description{
Summarize a parameter table from a \code{modsem} model.
}
\examples{
m1 <- '
  # Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

  # Inner Model
  Y ~ X + Z + X:Z
'
# Double centering approach
est_dca <- modsem(m1, oneInt)

std <- standardized_estimates(est_dca, correction = TRUE)
summarize_partable(std)
}
