% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marg.R
\name{marg}
\alias{marg}
\title{Estimating predictive margins on a model}
\usage{
marg(mod, var_interest, data = NULL, weights = NULL, vcov_mat = NULL,
  dof = NULL, type = "levels", base_rn = 1, at_var_interest = NULL,
  at = NULL, cofint = 0.95, ...)
}
\arguments{
\item{mod}{model object, currently only support those of class \code{\link[stats]{glm}}
or \code{\link[AER]{ivreg}}}

\item{var_interest}{name of the variable of interest, must correspond to a
covariate in the model}

\item{data}{data.frame that margins should run over, defaults changes based
on class-specific method}

\item{weights}{numeric, vector of weights used to generate predicted levels,
defaults changes based on class-specific method. Must be equal to the number
of rows in \code{data}.}

\item{vcov_mat}{the variance-covariance matrix,
defaults changes based on class-specific method}

\item{dof}{integer, the degrees of freedom used for the T statistic in an
OLS model, defaults changes based on class-specific method}

\item{type}{either \code{'levels'} (predicted outcomes) or \code{'effects'} \eqn{dydx},
defaults to \code{'levels'}}

\item{base_rn}{numeric, if \code{type == 'effects'}, the base level (taken as the
index of one of the ordered unique values in \code{var_interest}). if
\code{type == 'levels'}, this parameter is ignored. Defaults to 1.}

\item{at_var_interest}{vector, if type == 'levels', the values for the
variable of interest at which levels should be calculated.
If \code{NULL}, indicates all levels for a factor variable, defaults to \code{NULL}}

\item{at}{list, should be in the format of \code{list('var_name' = c(values))},
defaults to \code{NULL}. This calculates the margins of the variable at these
particular variables. If all values are needed, suggested syntax is
\code{at = list('var' = unique(df$var))}.}

\item{cofint}{numeric, confidence interval (must be less than 1), defaults to 0.95}

\item{...}{additional parameters passed to class-specific methods}
}
\value{
list of dataframes with predicted margins/effects, standard errors, p-values,
and confidence interval bounds
}
\description{
This function estimates the predictive effects and levels for variables within
a model using the delta method.
}
\details{
The variable for the predictive margin is specified by \code{var_interest}. If
margins are only needed at particular values of \code{var_interest},
\code{at_var_interest} should be used. If margins of \code{var_interest} are
needed at across the levels of a \emph{different} variable in the model,
\code{at} should be used.

If higher-order polynomial terms (e.g. \eqn{y ~ x + x^2}) are added
using the R function \code{\link[stats]{poly}}, the \code{raw = TRUE}
argument should be used to include the basic polynomial terms
instead of orthogonal polynomial terms. If orthogonal polynomials are used,
\code{marg} will fail when the user specifies \code{at} for a small set
of values for the variable in question (e.g. \code{at = list(x = 10)}),
since \code{poly} needs more data to calculate orthogonal polynomials
(e.g. \code{poly(10, 2)} fails, but \code{poly(c(10, 8, 3), 2)} will run).

P values are calculated with T tests for gaussian families, and Z tests
otherwise. If a new variance-covariance matrix is provided (e.g. for
clustering standard errors), the degrees of freedom for the T test / p-value
calculation may need to be specified using \code{dof}.

This function currently only supports \code{\link[stats]{glm}} and
\code{\link[AER]{ivreg}} objects. If you would like to use \code{lm}
objects, consider running a \code{glm} with family \code{gaussian}.

When calculating predicted levels and effects for models built using weights,
\code{marg} returns weighted averages for levels and effects by default.
Users can remove this option by setting \code{weights = NULL}.
}
