% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_skim.R
\name{datasummary_skim}
\alias{datasummary_skim}
\title{Quick overview of numeric or categorical variables}
\usage{
datasummary_skim(
  data,
  type = "numeric",
  output = "default",
  fmt = "\%.1f",
  histogram = TRUE,
  title = NULL,
  notes = NULL,
  align = NULL,
  escape = TRUE,
  ...
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{type}{of variables to summarize: "numeric" or "categorical" (character)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "modelsummary_list", "gt", "kableExtra", "huxtable", "flextable", "jupyter".
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
\item The default output formats and table-making packages can be modified with global options. See the 'Details' section.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
\item Note on LaTeX formatting: To ensure proper typography, all numeric entries are enclosed in the \verb{\\num\{\}} command from the \code{siunitx} LaTeX package by default. This behavior can be altered with global options. See the 'Details' section.
}}

\item{histogram}{include a histogram (TRUE/FALSE). Supported for:
\itemize{
\item type = "numeric"
\item output is "html", "default", "jpg", "png", or "kableExtra"
\item PDF and HTML documents compiled via Rmarkdown or knitr
\item See the examples section below for an example of how to use
\code{datasummary} to include histograms in other formats such as markdown.
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, S.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. Only supported for LaTeX/PDF tables produced by \code{kableExtra}. These commands must appear in the LaTeX preamble (they are added automatically when compiling Rmarkdown documents to PDF):
\itemize{
\item \verb{\\usepackage\{booktabs\}}
\item \verb{\\usepackage\{siunitx\}}
\item \verb{\\newcolumntype\{d\}\{S[input-symbols = ()]\}}
}
}}

\item{escape}{boolean TRUE escapes or substitutes LaTeX/HTML characters which could
prevent the file from compiling/displaying. This setting does not affect captions or notes.}

\item{...}{all other arguments are passed through to the
table-making functions. This allows users to pass arguments directly to
\code{datasummary} in order to affect the behavior of other functions behind
the scenes, for instance:
\itemize{
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
}}
}
\description{
This function was inspired by the excellent \code{skimr} package for R.
}
\examples{

\dontrun{
dat <- mtcars
dat$vs <- as.logical(dat$vs)
dat$cyl <- as.factor(dat$cyl)
datasummary_skim(dat)
datasummary_skim(dat, "categorical")

# You can use `datasummary` to produce a similar table in different formats.
# Note that the `Histogram` function relies on unicode characters. These
# characters will only display correctly in some operating systems, under some
# locales, using some fonts. Displaying such histograms on Windows computers
# is notoriously tricky. The `modelsummary` authors cannot provide support to
# display these unicode histograms.

f <- All(mtcars) ~ Mean + SD + Min + Median + Max + Histogram
datasummary(f, mtcars, output="markdown")

}
}
