% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelDown.R
\name{modelDown}
\alias{modelDown}
\title{Generates a website with HTML summaries for predictive models}
\usage{
modelDown(..., modules = c("auditor", "drifter", "model_performance",
  "variable_importance", "variable_response"), output_folder = "output",
  repository_name = "repository", should_open_website = TRUE)
}
\arguments{
\item{...}{one or more explainers created with \code{DALEX::explain()} function. Pair of explainer could be provided to check drift of models}

\item{modules}{modules that should be included in the website}

\item{output_folder}{folder where the website will be saved}

\item{repository_name}{name of local archivist repository that will be created}

\item{should_open_website}{should generated website be automatically opened in default browser}
}
\description{
Generates a website with HTML summaries for predictive models
}
\details{
Additional arguments that could by passed by name:
\itemize{
  \item{remote_repository_path} {Path to remote repository that stores folder with archivist repository. If not provided, links to local repository will be shown.}
  \item{device} {Device to use. Tested for "png" and "svg", but values from \code{ggplot2::ggsave} function should be working fine. Defaults to "png".}
  \item{vr.vars} {variables which will be examined in Variable Response module. Defaults to all variables. Example vr.vars = c("var1", "var2")}
  \item{vr.type} {types of examinations which will be conducteed in Variable Response module. Defaults to "pdp". Example vr.type = c("ale", "pdp")}
}
}
\examples{

require("DALEX")
require("breakDown")
require("DALEX")


# Generate simple modelDown page
HR_data_selected <- HR_data[1000:3000,]
HR_glm_model <- glm(left~., HR_data_selected, family = "binomial")
explainer_glm <- explain(HR_glm_model, data=HR_data_selected, y = HR_data_selected$left)

modelDown::modelDown(explainer_glm,
                     modules = c("model_performance", "variable_importance",
                                 "variable_response"),
                     output_folder = tempdir(),
                     repository_name = "HR",
                     device = "png",
                     vr.vars= c("average_montly_hours"),
                     vr.type = "ale")

\donttest{
# More complex example with all modules
HR_ranger_model <- ranger(as.factor(left) ~ .,
                      data = HR_data, num.trees = 500, classification = TRUE, probability = TRUE)
explainer_ranger <- explain(HR_ranger_model,
                      data = HR_data, y = HR_data$left, function(model, data) {
 return(predict(model, data)$prediction[,2])
}, na.rm=TRUE)

# Two glm models used for drift detection
HR_data1 <- HR_data[1:4000,]
HR_data2 <- HR_data[4000:nrow(HR_data),]
HR_glm_model1 <- glm(left~., HR_data1, family = "binomial")
HR_glm_model2 <- glm(left~., HR_data2, family = "binomial")
explainer_glm1 <- explain(HR_glm_model1, data=HR_data1, y = HR_data1$left)
explainer_glm2 <- explain(HR_glm_model2, data=HR_data2, y = HR_data2$left)

modelDown::modelDown(list(explainer_glm1, explainer_glm2),
  modules = c("auditor", "drifter", "model_performance", "variable_importance",
              "variable_response"),
  output_folder = tempdir(),
  repository_name = "HR",
  remote_repository_path = "some_user/remote_repo_name",
  device = "png",
  vr.vars= c("average_montly_hours", "time_spend_company"),
  vr.type = "ale")
}
}
\author{
Przemysław Biecek, Magda Tatarynowicz, Kamil Romaszko, Mateusz Urbański
}
