% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RetrafoState.R
\name{makeCPOTrainedFromState}
\alias{makeCPOTrainedFromState}
\title{Create a CPOTrained with Given Internal State}
\usage{
makeCPOTrainedFromState(constructor, state, get.inverter = FALSE)
}
\arguments{
\item{constructor}{[\code{\link{CPOConstructor}}]\cr
A cpo constructor.}

\item{state}{[\code{list}]\cr
A state gotten from another \code{\link{CPORetrafo}} or \code{\link{CPOInverter}} object using
\code{\link{getCPOTrainedState}}.}

\item{get.inverter}{[logical(1)]\cr
Whether to get a \code{\link{CPOInverter}}. Usually a \code{\link{CPORetrafo}} is
created. This must be \code{TRUE} if the \code{state} was created from a \code{\link{CPOInverter}},
\code{FALSE} otherwise. Default is \code{FALSE}.}
}
\value{
[\code{CPOTrained}]. A \code{\link{CPORetrafo}} or \code{\link{CPOInverter}}
  (as if retrieved using \code{\link{retrafo}} or \code{\link{inverter}} after
  a primitive \code{\link{CPO}} was applied to some data) with the given state.
}
\description{
This creates a new \code{\link{CPOTrained}} object which will
behave according to the given state. The state should usually be obtained using
\code{\link{getCPOTrainedState}} and then slightly modified. No checks for correctness
of the state will (or can) be done, it is the user's responsibility to ensure
that the correct \code{\link{CPOConstructor}} is used, and that the state is
only modified in a way the CPO can handle.
}
\seealso{
Other state functions: \code{\link{getCPOTrainedState}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}}, \code{\link{pipeCPO}},
  \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}}, \code{\link{pipeCPO}},
  \code{\link{print.CPOConstructor}}
}
\concept{inverter related}
\concept{retrafo related}
\concept{state functions}
