% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOProperties}
\alias{getCPOProperties}
\alias{CPOProperties}
\alias{getCPOProperties.CPOTrained}
\title{Get the Properties of the Given CPO Object}
\usage{
getCPOProperties(cpo, only.data = FALSE, get.internal = FALSE)

\method{getCPOProperties}{CPOTrained}(cpo, only.data = FALSE,
  get.internal = FALSE)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}

\item{only.data}{[\code{logical(1)}]\cr
Only get the CPO \emph{data properties} (not target or task type properties). Default is \code{FALSE}.}

\item{get.internal}{[\code{logical(1)}]\cr
Also retrieve \code{$adding.min} and \code{$needed.max}. Default is \code{FALSE}.}
}
\value{
[\code{list}]. A \code{list} with slots \code{$handling}, \code{$adding}, and \code{$needed};
  also \code{$adding.min} and \code{$needed.max} if \code{get.internal} is \code{TRUE}.
}
\description{
The properties of a \code{\link{CPO}} object determine the kind of data the CPO will be able to handle, and how
it transforms data. Properties describe what kind of data a CPO can work with.

By default, this function returns a list of three values: \code{$handling}, \code{$adding}, and
\code{$needed}.

The \code{$handling} determines what data the CPO handles. If a CPO is applied to a data set
(using \code{\link{\%>>\%}} or \code{\link{applyCPO}}, or indirectly when a \code{\link{CPOLearner}} is trained)
that has a property not listed in \code{$handling}, an error will be given.

\code{$adding} can be one or many of the same values as \code{$handling}. These properties
get added to a \code{\link[mlr:makeLearner]{Learner}} or CPO coming after / behind this CPO. When a CPO imputes missing values, for example,
this is \dQuote{missings}. This is always a subset of \code{$handling}.

\code{$properties.needed} can be one or many of the same values as \code{$handling}. These properties
are required from a Learner (or CPO) coming after / behind this CPO. E.g., when a CPO converts factors to
numerics, this is \dQuote{numerics} (and \code{$adding} would be \dQuote{factors} in this case).
\code{$adding} and \code{$needed} never have any value in common.

There are two more properties mostly for internal usage: \code{$adding.min} and \code{$needed.max}.
These are for internal checking of trafo / retrafo function return values: If some
hyperparameter settings lead to a CPO returning values not conforming to properties (e.g. not
removing all \sQuote{missings}, or creating \sQuote{missings} where there were none before),
while in other cases the CPO \emph{does} conform, it is desirable to treat the CPO like
it behaves in the best case (and rely on the user to make good hyperparameter choices).
The properties discussed so far thus represent the CPO on its \sQuote{best} behaviour.
Internally, each CPO also has a list of properties that it minimally \sQuote{adds} to its successors
or maximally \sQuote{needs} from it in the worst case. These are \code{$adding.min} and \code{$needed.max}.
\code{$adding.min} is always a subset of \code{$adding}, \code{$needed.max} is always a superset of \code{needed}.
Their compliance is checked by the CPO framework, so a CPO that doesn't conform to these crashes.
}
\section{Possible properties}{

\describe{
  \item{data properties}{\dQuote{numerics}, \dQuote{factors}, \dQuote{ordered}, \dQuote{missings}:
    Whether any data column contains the type in question, or has missings. When \code{only.data}
    is \code{TRUE}, only these are returned.}
  \item{task type properties}{\dQuote{cluster} \dQuote{classif} \dQuote{multilabel} \dQuote{regr} \dQuote{surv}:
    The type of the task. \code{\link[base]{data.frame}} data objects have the implicit property \dQuote{cluster}.}
  \item{target properties}{\dQuote{oneclass} \dQuote{twoclass} \dQuote{multiclass}:
    Whether the target column of a \code{classif} task has one, two, or more classes.}
}
}

\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOAffect}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{setCPOId}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}
}
\concept{getters and setters}
\concept{inverter related}
\concept{retrafo related}
