% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOName}
\alias{getCPOName}
\alias{getCPOName.CPOTrained}
\alias{getCPOName.CPOConstructor}
\title{Get the CPO Object's Name}
\usage{
getCPOName(cpo)

\method{getCPOName}{CPOTrained}(cpo)

\method{getCPOName}{CPOConstructor}(cpo)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}
}
\value{
[\code{character(1)}] the CPO's name.
}
\description{
Return the name associated with a \code{\link{CPO}} operation. This name
is set when creating a \code{\link{CPOConstructor}}, e.g. using
\code{\link{makeCPO}}, by the \dQuote{.cpo.name} parameter.
It is also the default \code{id}, as retrieved by \code{\link{getCPOId}},
of a CPO.
}
\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOAffect}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{setCPOId}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other CPOConstructor related: \code{\link{CPOConstructor}},
  \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{identicalCPO}}, \code{\link{makeCPO}},
  \code{\link{print.CPOConstructor}}
}
