% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionRegr.R
\name{autoplot.PredictionRegr}
\alias{autoplot.PredictionRegr}
\title{Plot for PredictionRegr}
\usage{
\method{autoplot}{PredictionRegr}(object, type = "xy", ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionRegr]{mlr3::PredictionRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:PredictionRegr]{mlr3::PredictionRegr}, depending on argument \code{type}:
\itemize{
\item \code{"xy"} (default): Scatterplot of "true" response vs. "predicted" response.
By default a linear model is fitted via \code{geom_smooth(method = "lm")}
to visualize the trend between x and y (by default colored blue).
\itemize{
\item In addition \code{geom_abline()} with \code{slope = 1} is added to the plot.
\item Note that \code{geom_smooth()} and \code{geom_abline()} may overlap, depending on
the given data.
}
\item \code{"histogram"}: Histogram of residuals:
\eqn{r = y - \hat{y}}{r = y - y.hat}.
\item \code{"residual"}: Plot of the residuals, with the response \eqn{\hat{y}}{y.hat}
on the "x" and the residuals on the "y" axis.
\itemize{
\item By default a linear model is fitted via \code{geom_smooth(method = "lm")}
to visualize the trend between x and y (by default colored blue).
}
}
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("boston_housing")
  learner = lrn("regr.rpart")
  object = learner$train(task)$predict(task)

  head(fortify(object))
  autoplot(object)
  autoplot(object, type = "histogram", binwidth = 1)
  autoplot(object, type = "residual")
}
}
