% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_tiny_imagenet.R
\name{mlr_tasks_tiny_imagenet}
\alias{mlr_tasks_tiny_imagenet}
\title{Tiny ImageNet Classification Task}
\description{
Subset of the famous ImageNet dataset.
The data is obtained from \code{\link[torchvision:tiny_imagenet_dataset]{torchvision::tiny_imagenet_dataset()}}.

The underlying \code{\link[mlr3:DataBackend]{DataBackend}} contains columns \code{"class"}, \code{"image"}, \code{"..row_id"}, \code{"split"}, where the last column
indicates whether the row belongs to the train, validation or test set that are provided in torchvision.

There are no labels for the test rows, so by default, these observations are inactive, which means that the task
uses only 110000 of the 120000 observations that are defined in the underlying data backend.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{tsk("tiny_imagenet")
}\if{html}{\out{</div>}}
}

\section{Download}{

The \link[mlr3:Task]{task}'s backend is a \code{\link{DataBackendLazy}} which will download the data once it is requested.
Other meta-data is already available before that.
You can cache these datasets by setting the \code{mlr3torch.cache} option to \code{TRUE} or to a specific path to be used
as the cache directory.
}

\section{Properties}{

\itemize{
\item Task type: \dQuote{classif}
\item Properties: \dQuote{multiclass}
\item Has Missings: no
\item Target: \dQuote{class}
\item Features: \dQuote{image}
\item Data Dimension: 120000x4
}
}

\examples{
task = tsk("tiny_imagenet")
}
\references{
Deng, Jia, Dong, Wei, Socher, Richard, Li, Li-Jia, Li, Kai, Fei-Fei, Li (2009).
\dQuote{Imagenet: A large-scale hierarchical image database.}
In \emph{2009 IEEE conference on computer vision and pattern recognition}, 248--255.
IEEE.
}
