% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_graph.R
\name{nn_graph}
\alias{nn_graph}
\title{Graph Network}
\usage{
nn_graph(graph, shapes_in, output_map = graph$output$name, list_output = FALSE)
}
\arguments{
\item{graph}{(\code{\link[mlr3pipelines:Graph]{Graph}})\cr
The \code{\link[mlr3pipelines:Graph]{Graph}} to wrap. Is \strong{not} cloned.}

\item{shapes_in}{(named \code{integer})\cr
Shape info of tensors that go into \code{graph}. Names must be \code{graph$input$name}, possibly in different order.}

\item{output_map}{(\code{character})\cr
Which of \code{graph}'s outputs to use. Must be a subset of \code{graph$output$name}.}

\item{list_output}{(\code{logical(1)})\cr
Whether output should be a list of tensors. If \code{FALSE} (default), then \code{length(output_map)} must be 1.}
}
\value{
\code{\link{nn_graph}}
}
\description{
Represents a neural network using a \code{\link[mlr3pipelines:Graph]{Graph}} that usually costains mostly \code{\link{PipeOpModule}}s.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
graph = mlr3pipelines::Graph$new()
graph$add_pipeop(po("module_1", module = nn_linear(10, 20)), clone = FALSE)
graph$add_pipeop(po("module_2", module = nn_relu()), clone = FALSE)
graph$add_pipeop(po("module_3", module = nn_linear(20, 1)), clone = FALSE)
graph$add_edge("module_1", "module_2")
graph$add_edge("module_2", "module_3")

network = nn_graph(graph, shapes_in = list(module_1.input = c(NA, 10)))

x = torch_randn(16, 10)

network(module_1.input = x)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Graph Network: 
\code{\link{ModelDescriptor}()},
\code{\link{TorchIngressToken}()},
\code{\link{mlr_learners_torch_model}},
\code{\link{mlr_pipeops_module}},
\code{\link{mlr_pipeops_torch}},
\code{\link{mlr_pipeops_torch_ingress}},
\code{\link{mlr_pipeops_torch_ingress_categ}},
\code{\link{mlr_pipeops_torch_ingress_ltnsr}},
\code{\link{mlr_pipeops_torch_ingress_num}},
\code{\link{model_descriptor_to_learner}()},
\code{\link{model_descriptor_to_module}()},
\code{\link{model_descriptor_union}()}
}
\concept{Graph Network}
