% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TorchCallback.R
\name{TorchCallback}
\alias{TorchCallback}
\title{Torch Callback}
\description{
This wraps a \code{\link{CallbackSet}} and annotates it with metadata, most importantly a \code{\link[paradox:ParamSet]{ParamSet}}.
The callback is created for the given parameter values by calling the \verb{$generate()} method.

This class is usually used to configure the callback of a torch learner, e.g. when constructing
a learner of in a \code{\link{ModelDescriptor}}.

For a list of available callbacks, see \code{\link{mlr3torch_callbacks}}.
To conveniently retrieve a \code{\link{TorchCallback}}, use \code{\link[=t_clbk]{t_clbk()}}.
}
\section{Parameters}{

Defined by the constructor argument \code{param_set}.
If no parameter set is provided during construction, the parameter set is constructed by creating a parameter
for each argument of the wrapped loss function, where the parametes are then of type \code{ParamUty}.
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new torch callback from an existing callback set
torch_callback = TorchCallback$new(CallbackSetCheckpoint)
# The parameters are inferred
torch_callback$param_set

# Retrieve a torch callback from the dictionary
torch_callback = t_clbk("checkpoint",
  path = tempfile(), freq = 1
)
torch_callback
torch_callback$label
torch_callback$id

# open the help page of the wrapped callback set
# torch_callback$help()

# Create the callback set
callback = torch_callback$generate()
callback
# is the same as
CallbackSetCheckpoint$new(
  path = tempfile(), freq = 1
)

# Use in a learner
learner = lrn("regr.mlp", callbacks = t_clbk("checkpoint"))
# the parameters of the callback are added to the learner's parameter set
learner$param_set
\dontshow{\}) # examplesIf}
}
\seealso{
Other Callback: 
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}

Other Torch Descriptor: 
\code{\link{TorchDescriptor}},
\code{\link{TorchLoss}},
\code{\link{TorchOptimizer}},
\code{\link{as_torch_callbacks}()},
\code{\link{as_torch_loss}()},
\code{\link{as_torch_optimizer}()},
\code{\link{mlr3torch_losses}},
\code{\link{mlr3torch_optimizers}},
\code{\link{t_clbk}()},
\code{\link{t_loss}()},
\code{\link{t_opt}()}
}
\concept{Callback}
\concept{Torch Descriptor}
\section{Super class}{
\code{\link[mlr3torch:TorchDescriptor]{mlr3torch::TorchDescriptor}} -> \code{TorchCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TorchCallback-new}{\code{TorchCallback$new()}}
\item \href{#method-TorchCallback-clone}{\code{TorchCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="generate"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-generate'><code>mlr3torch::TorchDescriptor$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="help"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-help'><code>mlr3torch::TorchDescriptor$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="TorchDescriptor" data-id="print"><a href='../../mlr3torch/html/TorchDescriptor.html#method-TorchDescriptor-print'><code>mlr3torch::TorchDescriptor$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-TorchCallback-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchCallback$new(
  callback_generator,
  param_set = NULL,
  id = NULL,
  label = NULL,
  packages = NULL,
  man = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback_generator}}{(\code{R6ClassGenerator})\cr
The class generator for the callback that is being wrapped.}

\item{\code{param_set}}{(\code{ParamSet} or \code{NULL})\cr
The parameter set. If \code{NULL} (default) it is inferred from \code{callback_generator}.}

\item{\code{id}}{(\code{character(1)})\cr
The id for of the new object.}

\item{\code{label}}{(\code{character(1)})\cr
Label for the new instance.}

\item{\code{packages}}{(\code{character()})\cr
The R packages this object depends on.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TorchCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TorchCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TorchCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
