% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/po.R
\name{po}
\alias{po}
\title{Shorthand PipeOp Constructor}
\usage{
po(.obj, ...)
}
\arguments{
\item{.obj}{\code{[any]}\cr
The object from which to construct a \code{PipeOp}. If this is a
\code{character(1)}, it is looked up in the \code{\link{mlr_pipeops}} dictionary.
Otherwise, it is converted to a \code{PipeOp}.}

\item{...}{\code{any}\cr
Additional parameters to give to constructed object.
This may be an argument of the constructor of the
\code{PipeOp}, in which case it is given to this constructor;
or it may be a parameter value, in which case it is
given to the \code{param_vals} argument of the constructor.}
}
\description{
Create
\itemize{
\item a \code{PipeOp} from \code{mlr_pipeops} from given ID
\item a \code{PipeOpLearner} from a \code{Learner} object
\item a \code{PipeOpFilter} from a \code{Filter} object
}

The object is initialized with given parameters and \code{param_vals}.
}
\examples{
library("mlr3")

po("learner", lrn("classif.rpart"), cp = 0.3)

po(lrn("classif.rpart"), cp = 0.3)

# is equivalent with:
mlr_pipeops$get("learner", lrn("classif.rpart"),
  param_vals = list(cp = 0.3))
}
