% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLTask.R
\name{OMLTask}
\alias{OMLTask}
\title{Interface to OpenML Tasks}
\description{
This is the class for tasks served on \url{https://openml.org/t}.
}
\section{mlr3 Integration}{

A \link[mlr3:Task]{mlr3::Task} is returned by the method \verb{$task}.
Alternatively, you can convert this object to a \link[mlr3:DataBackend]{mlr3::DataBackend} using
\code{mlr3::as_data_backend()}.
}

\examples{
\donttest{
otask = OMLTask$new(id = 59)

print(otask)
print(otask$target_names)
print(otask$feature_names)
print(otask$tags)
print(otask$task)

# get a task via tsk():
if (requireNamespace("mlr3")) {
  mlr3::tsk("oml", task_id = 59)
}
}
}
\references{
Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML task id.}

\item{\code{cache_dir}}{(\code{logical(1)} | \code{character(1)})\cr
Stores the location of the cache for objects retrieved from \url{https://openml.org}.
If set to \code{FALSE}, caching is disabled.

The package \CRANpkg{qs} is required for caching.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{(\code{character(1)})\cr
Name of the task, as extracted from the task description.}

\item{\code{desc}}{(\code{list()})\cr
Task description (meta information), downloaded and converted from the JSON API response.}

\item{\code{data_id}}{(\code{integer()})\cr
Data id, extracted from the task description.}

\item{\code{data}}{(\link{OMLData})\cr
Access to the underlying OpenML data set via a \link{OMLData} object.}

\item{\code{nrow}}{(\code{integer()})\cr
Number of rows, as extracted from the \link{OMLData} object.}

\item{\code{ncol}}{(\code{integer()})\cr
Number of columns, as extracted from the \link{OMLData} object.}

\item{\code{target_names}}{(\code{character()})\cr
Name of the targets, as extracted from the OpenML task description.}

\item{\code{feature_names}}{(\code{character()})\cr
Name of the features, as extracted from the \link{OMLData} object.}

\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task})\cr
Creates a \link[mlr3:Task]{mlr3::Task} using the target attribute of the task desc.}

\item{\code{resampling}}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
Creates a \link[mlr3:mlr_resamplings_custom]{ResamplingCustom} using the target attribute of the task description.}

\item{\code{tags}}{(\code{character()})\cr
Returns all tags of the task.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OMLTask$new()}}
\item \href{#method-print}{\code{OMLTask$print()}}
\item \href{#method-clone}{\code{OMLTask$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new object of class \code{OMLTask}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$new(id, cache = getOption("mlr3oml.cache", FALSE))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML task id.}

\item{\code{cache}}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
For a more detailed printer, convert to a \link[mlr3:Task]{mlr3::Task} via \verb{$task}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLTask$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
