% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterMIM.R
\docType{data}
\name{FilterMIM}
\alias{FilterMIM}
\alias{mlr_filters_mim}
\title{Conditional Mutual Information Based Feature Selection Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Conditional mutual information based feature selection filter
calling \code{\link[praznik:MIM]{praznik::MIM()}} in package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\section{Construction}{
\preformatted{FilterMIM$new()
mlr_filters$get("mim")
flt("mim")
}
}

\examples{
task = mlr3::tsk("iris")
filter = flt("mim")
filter$calculate(task, nfeat = 2)
as.data.table(filter)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterInformationGain}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
