% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDAExtract.R
\name{mlr_pipeops_fda.extract}
\alias{mlr_pipeops_fda.extract}
\alias{PipeOpFDAExtract}
\title{Extracts Simple Features from Functional Columns}
\description{
This is the class that extracts simple features from functional columns.
Note that it only operates on values that were actually observed and does not interpolate.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreprocSimple}}, as well as the following
parameters:
\itemize{
\item \code{drop} :: \code{logical(1)}\cr
Whether to drop the original \code{functional} features and only keep the extracted features.
Note that this does not remove the features from the backend, but only from the active
column role \code{feature}. Initial value is \code{TRUE}.
\item \code{features} :: \code{list()} | \code{character()} \cr
A list of features to extract. Each element can be either a function or a string.
If the element if is function it requires the following arguments: \code{arg} and \code{value} and returns a \code{numeric}.
For string elements, the following predefined features are available:
\code{"mean"}, \code{"max"},\code{"min"},\code{"slope"},\code{"median"},\code{"var"}.
Initial is \code{c("mean", "max", "min", "slope", "median", "var")}
\item \code{left} :: \code{numeric()} \cr
The left boundary of the window. Initial is \code{-Inf}.
The window is specified such that the all values >=left and <=right are kept for the computations.
\item \code{right} :: \code{numeric()} \cr
The right boundary of the window. Initial is \code{Inf}.
}
}

\section{Naming}{

The new names generally append a \verb{_\{feature\}} to the corresponding column name.
However this can lead to name clashes with existing columns.
This is solved as follows:
If a column was called \code{"x"} and the feature is \code{"mean"}, the corresponding new column will
be called \code{"x_mean"}. In case of duplicates, unique names are obtained using \code{make.unique()} and
a warning is given.
}

\examples{
library(mlr3pipelines)

task = tsk("fuel")
po_fmean = po("fda.extract", features = "mean")
task_fmean = po_fmean$train(list(task))[[1L]]

# add more than one feature
pop = po("fda.extract", features = c("mean", "median", "var"))
task_features = pop$train(list(task))[[1L]]

# add a custom feature
po_custom = po("fda.extract",
  features = list(mean = function(arg, value) mean(value, na.rm = TRUE))
)
task_custom = po_custom$train(list(task))[[1L]]
task_custom
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDAExtract}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDAExtract-new}{\code{PipeOpFDAExtract$new()}}
\item \href{#method-PipeOpFDAExtract-clone}{\code{PipeOpFDAExtract$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAExtract-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAExtract-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAExtract$new(id = "fda.extract", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default is \code{"fda.extract"}.}

\item{\code{param_vals}}{(named \code{list})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDAExtract-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDAExtract-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDAExtract$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
