% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_tasks.R
\docType{data}
\name{mlr_tasks}
\alias{mlr_tasks}
\title{Dictionary of Tasks}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.}
\description{
A simple \link{Dictionary} storing objects of class \link{Task}.
Each task has an associated help page, see \code{mlr_tasks_[id]}.
}
\section{Methods}{

See \link{Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict)}\cr
\link{Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with columns \code{"key"}, \code{"task_type"}, \code{"measures"}, \code{"nrow"}, \code{"ncol"} and
the number of features of type \code{"lgl"}, \code{"int"}, \code{"dbl"}, \code{"chr"}, \code{"fct"} and \code{"ord"} as columns.
}
}

\examples{
as.data.table(mlr_tasks)
mlr_tasks$get("iris")
head(mlr_tasks$get("iris")$data())

# Add a new task, based on a subset of iris:
data = iris
data$Species = factor(ifelse(data$Species == "setosa", "1", "0"))
task = TaskClassif$new("iris.binary", data, target = "Species", positive = "1")

# add to dictionary
mlr_tasks$add("iris.binary", task)

# list available tasks
mlr_tasks$keys()

# retrieve from dictionary
mlr_tasks$get("iris.binary")

# remove task again
mlr_tasks$remove("iris.binary")
}
\seealso{
Example tasks:
\itemize{
\item \code{\link[=mlr_tasks_iris]{iris}} (multi-class classification)
\item \code{\link[=mlr_tasks_spam]{spam}} (binary classification)
\item \code{\link[=mlr_tasks_boston_housing]{boston_housing}} (regression)
}

Other Dictionary: \code{\link{mlr_generators}},
  \code{\link{mlr_learners}}, \code{\link{mlr_measures}},
  \code{\link{mlr_resamplings}}

Other Task: \code{\link{TaskClassif}},
  \code{\link{TaskRegr}}, \code{\link{TaskSupervised}},
  \code{\link{Task}}
}
\concept{Dictionary}
\concept{Task}
\keyword{datasets}
