% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionRegr.R
\docType{data}
\name{PredictionRegr}
\alias{PredictionRegr}
\title{Prediction Object for Regression}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Prediction}.}
\description{
This object wraps the predictions returned by a learner of class \link{LearnerRegr}, i.e.
the predicted response and standard error.
}
\section{Construction}{
\preformatted{p = PredictionRegr$new(task = NULL, row_ids = task$row_ids, truth = task$truth(), response = NULL, se = NULL)
}
\itemize{
\item \code{task} :: \link{TaskRegr}\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.
\item \code{row_ids} :: (\code{integer()} | \code{character()})\cr
Row ids of the observations in the test set.
\item \code{truth} :: \code{numeric()}\cr
True (observed) response.
\item \code{response} :: \code{numeric()}\cr
Vector of numeric response values.
One element for each observation in the test set.
\item \code{se} :: \code{numeric()}\cr
Numeric vector of predicted standard error.
One element for each observation in the test set.
}
}

\section{Fields}{

All fields from \link{Prediction}, and additionally:
\itemize{
\item \code{response} :: \code{numeric()}\cr
Access to the stored predicted response.
\item \code{se} :: \code{numeric()}\cr
Access to the stored standard error.
}

The field \code{task_type} is set to \code{"regr"}.
}

\examples{
task = mlr_tasks$get("boston_housing")
learner = mlr_learners$get("regr.featureless")
learner$predict_type = "se"
p = learner$train(task)$predict(task)
p$predict_types
head(as.data.table(p))
}
\seealso{
Other Prediction: \code{\link{PredictionClassif}},
  \code{\link{Prediction}}
}
\concept{Prediction}
\keyword{datasets}
