% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectivity_funcs.R
\name{knife_edge}
\alias{knife_edge}
\title{Weight based knife-edge selectivity function}
\usage{
knife_edge(w, knife_edge_size, ...)
}
\arguments{
\item{w}{Vector of sizes.}

\item{knife_edge_size}{The weight at which the knife-edge operates.}

\item{...}{Unused}
}
\value{
Vector of selectivities at the given sizes.
}
\description{
A knife-edge selectivity function where weights greater or equal to
\code{knife_edge_size} are fully selected and no fish smaller than this size
are selected.
}
\seealso{
\code{\link[=gear_params]{gear_params()}} for setting the \code{knife_edge_size} parameter.

Other selectivity functions: 
\code{\link{double_sigmoid_length}()},
\code{\link{sigmoid_length}()},
\code{\link{sigmoid_weight}()}
}
\concept{selectivity functions}
