% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_params.R
\name{species_params}
\alias{species_params}
\alias{species_params<-}
\title{Species parameters}
\usage{
species_params(params)

species_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A data frame with the species parameters}
}
\description{
These functions allow you to get or set the species parameters stored in
a MizerParams object.
}
\details{
The \code{species_params} data frame holds species-specific parameters that Mizer
can use, together with allometric assumptions, to set its various
size-dependent parameters. The data frame has one row for each species and
one column for each species parameter. There are a lot of species parameters
as we will now discuss, but most of them have sensible default values.
\itemize{
\item \code{gamma} and \code{q} are used to set the search volume, see \code{\link[=setSearchVolume]{setSearchVolume()}}.
\item \code{h} and \code{n} are used to set the maximum intake rate, see \code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
\item \code{k}, \code{ks} and \code{p} are used to set activity and basic metabolic rate,
see \code{\link[=setMetabolicRate]{setMetabolicRate()}}.
\item \code{z0} is used to set the external mortality rate, see \code{\link[=setExtMort]{setExtMort()}}.
\item \code{w_mat}, \code{w_mat25}, \code{w_inf} and \code{m} are used to set the allocation to
reproduction, see \code{\link[=setReproduction]{setReproduction()}}.
\item \code{w_min} is the egg size.
\item \code{beta} and \code{sigma} are parameters of the lognormal predation kernel, see
\code{\link[=lognormal_pred_kernel]{lognormal_pred_kernel()}}. There will be other parameters if you are
using other predation kernel functions, see the "Setting predation kernel"
section in the help for \code{\link[=setPredKernel]{setPredKernel()}}.
}

Not all of these parameters have to be specified by the user. If they are
missing, mizer will give them default values, sometimes by using other
species parameters.
\itemize{
\item \code{k_vb} and \code{t0} are the von Bertalanffy growth parameters and are used
together with the length-weight relationship exponent \code{b} and the egg
size \code{w_min} to
get a default value for the coefficient of the maximum intake rate \code{h},
see \code{\link[=get_h_default]{get_h_default()}}.
\item \code{f0} is the feeding level and is used to get a default value for the
coefficient of the search volume \code{gamma}, see \code{\link[=get_gamma_default]{get_gamma_default()}}.
\item \code{fc} is the critical feeding level below which the species can not
maintain itself. This is used to get a default value for the coefficient
of the metabolic rate \code{ks}, see \code{\link[=get_ks_default]{get_ks_default()}}.
}

Note that these parameters are ignored if the parameters for which they allow
defaults to be calculated have instead been set explicitly.

There are also some species parameters that are used directly in the model
rather than being used for setting up size-dependent parameters:
\itemize{
\item \code{alpha} is the assimilation efficiency, the proportion of the consumed
biomass that can be used for growth, metabolism and reproduction, see
the help for \code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}.
\item \code{interaction_resource} sets the interaction strength with the resource,
see "Predation encounter" section in the help for \code{\link[=getEncounter]{getEncounter()}}.
\item \code{erepro} is the reproductive efficiency, the proportion of the energy
invested into reproduction that is converted to egg biomass, see
\code{\link[=getRDI]{getRDI()}}.
\item \code{Rmax} is the parameter in the Beverton-Holt density dependence added to
the reproduction, see \code{\link[=BevertonHoltRDD]{BevertonHoltRDD()}}. There will be other such
parameters if you use other density dependence functions, see the
"Density dependence" section in the help for \code{\link[=setReproduction]{setReproduction()}}.
}

When you set up a MizerParams object with \code{\link[=newMultispeciesParams]{newMultispeciesParams()}} you
need to specify a species parameter data frame, but you do not need to
give values for all of the species parameters described above. The only
required columns are \code{species} for the species name and \code{w_inf} for its
asymptotic size. Mizer will choose default values for all others, see
\code{\link[=newMultispeciesParams]{newMultispeciesParams()}}.

When you change a species parameter in an already existing MizerParams
object, then this will be used to update the corresponding size-dependent
rates by automatically calling \code{\link[=setParams]{setParams()}}.
}
\seealso{
\code{\link[=validSpeciesParams]{validSpeciesParams()}}

Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()}
}
\concept{functions for setting parameters}
