% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getEReproAndGrowth}
\alias{getEReproAndGrowth}
\title{Get energy rate available for reproduction and growth}
\usage{
getEReproAndGrowth(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  encounter = getEncounter(params, n = n, n_pp = n_pp, n_other = n_other),
  feeding_level = getFeedingLevel(params, n = n, n_pp = n_pp, n_other = n_other,
    encounter = encounter)
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{encounter}{The encounter rate matrix (optional) of dimension no.
species x no. size bins. If not passed in, it is calculated internally
using the \code{\link[=getEncounter]{getEncounter()}} function.}

\item{feeding_level}{The current feeding level (optional). A matrix of size
no. species x no. size bins. If not supplied, is calculated internally
using the \code{\link[=getFeedingLevel]{getFeedingLevel()}} function.}
}
\value{
A two dimensional array (species x size) holding
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, (1 - {\tt feeding\_level}_i(w))\, 
                           {\tt encounter}_i(w) - {\tt metab}_i(w)).}{
  E_{r.i}(w) = max(0, alpha_i * (1 - feeding_level_i(w)) * 
                      encounter_i(w) - metab_i(w)).}
Due to the form of the feeding level, calculated by
\code{\link[=getFeedingLevel]{getFeedingLevel()}}, this can also be expressed as
\deqn{E_{r.i}(w) = \max(0, \alpha_i\, {\tt feeding\_level}_i(w)\, 
                           h_i(w) - {\tt metab}_i(w))}{
  E_{r.i}(w) = max(0, alpha_i * feeding_level_i(w) * 
                      h_i(w) - metab_i(w))}
where \eqn{h_i} is the maximum intake rate, set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
The assimilation rate \eqn{\alpha_i} is taken from the species parameter
data frame in \code{params}. The metabolic rate \code{metab} is taken from
\code{params} and set with \code{\link[=setMetabolicRate]{setMetabolicRate()}}.

The return value can be negative, which means that the energy intake does not
cover the cost of metabolism and movement.
}
\description{
Calculates the energy rate \eqn{E_{r.i}(w)} (grams/year) available for
reproduction and growth after metabolism and movement have been accounted
for.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the energy at a particular time step
getEReproAndGrowth(params,sim@n[21,,],sim@n_pp[21,])
}
}
\seealso{
The parts of this energy rate that is invested into growth is
calculated with \code{\link[=getERepro]{getERepro()}} and the part that is invested into
reproduction is calculated with \code{\link[=getEGrowth]{getEGrowth()}}.

Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
