% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-binom.R
\name{Mixture Link Binomial Distribution}
\alias{Mixture Link Binomial Distribution}
\alias{d.mixlink.binom}
\alias{p.mixlink.binom}
\alias{r.mixlink.binom}
\title{Distribution functions}
\usage{
r.mixlink.binom(n, mean, Pi, kappa, m, save.latent = FALSE)

d.mixlink.binom(y, m, mean, Pi, kappa, log = FALSE)

p.mixlink.binom(y, m, mean, Pi, kappa)
}
\arguments{
\item{n}{Number of observations to draw}

\item{mean}{Parameter \eqn{\vartheta} of distribution}

\item{Pi}{Parameter \eqn{\bm{\pi}} of distribution}

\item{kappa}{Parameter \eqn{\kappa} of distribution}

\item{m}{Number of success/failure trials}

\item{save.latent}{Save intermediate latent variables used during draw.}

\item{y}{Argument of pdf or cdf}

\item{log}{Return log of the result (TRUE or FALSE)}
}
\value{
\code{d.mixlink.binom} gives the density,
        \code{p.mixlink.binom} gives the distribution function, and
        \code{r.mixlink.binom} generates random deviates.
}
\description{
Functions for Mixture Link Binomial distribution
}
\examples{
  mean.true <- 1/3
  Pi.true <- c(1/5, 4/5)
  kappa.true <- 0.5
  m <- 10
  r.mixlink.binom(n = 30, mean.true, Pi.true, kappa.true, m)
  d.mixlink.binom(y = 5, m, mean.true, Pi.true, kappa.true)
  d.mixlink.binom(y = 5, m, mean.true, Pi.true, kappa.true, log = TRUE)
  p.mixlink.binom(y = 5, m, mean.true, Pi.true, kappa.true)
}
\references{
Andrew M. Raim, Nagaraj K. Neerchal, and Jorge G. Morel.
            An Extension of Generalized Linear Models to Finite
            Mixture Outcomes. arXiv preprint: 1612.03302
}

