% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_2vars.R
\name{plot_2num}
\alias{plot_2num}
\title{Scatter plots for two imputed numeric variables}
\usage{
plot_2num(
  imputation.list,
  var.x,
  var.y,
  original.data,
  true.data = NULL,
  color.pal = NULL,
  shape = FALSE
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer}

\item{var.x}{A numeric variable on the x-axis}

\item{var.y}{A numeric variable on the y-axis}

\item{original.data}{The original data with missing data}

\item{true.data}{The true data without missing values. This is generally unknown in practice. If the true data is known (e.g., in cases where it is generated by simulation), it can be specified in this argument. The output will then have an extra panel called \code{MaskedTrue}, which shows values originally observed but intentionally made missing.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}

\item{shape}{Whether to plot shapes for different types of missing values. By default, this is set to FALSE to speed up plotting. We only recommend using `shape = TRUE` for small datasets.}
}
\value{
Scatter plots for two numeric/integer variable
}
\description{
Plot observed values versus m sets of imputed values for two specified numeric variables using \pkg{ggplot2}.
}
\examples{
# obtain m multiply datasets
params <- list(max_depth = 3, subsample = 0.8, nthread = 2)
imputed.data <- mixgb(data = nhanes3, m = 3, xgb.params = params, nrounds = 30)

# plot the multiply imputed values for variables "BMPRECUM" versus "BMPHEAD"
plot_2num(
  imputation.list = imputed.data, var.x = "BMPHEAD", var.y = "BMPRECUM",
  original.data = nhanes3
)
}
