% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_3vars.R
\name{plot_1num2fac}
\alias{plot_1num2fac}
\title{Box plots with overlaying data points for a numeric variable vs a factor condition on another factor}
\usage{
plot_1num2fac(
  imputation.list,
  var.fac,
  var.num,
  con.fac,
  original.data,
  true.data = NULL,
  color.pal = NULL,
  shape = FALSE
)
}
\arguments{
\item{imputation.list}{A list of \code{m} imputed datasets returned by the \code{mixgb} imputer}

\item{var.fac}{A factor variable on the x-axis}

\item{var.num}{A numeric variable on the y-axis}

\item{con.fac}{The name of a factor to condition on}

\item{original.data}{The original data with missing data}

\item{true.data}{The true data without missing values. This is generally unknown in practice. If the true data is known (e.g., in cases where it is generated by simulation), it can be specified in this argument. The output will then have an extra panel called \code{MaskedTrue}, which shows values originally observed but intentionally made missing.}

\item{color.pal}{A vector of hex color codes for the observed and m sets of imputed values panels. The vector should be of length \code{m+1}. Default: NULL (use "gray40" for the observed panel, use ggplot2 default colors for other panels.)}

\item{shape}{Whether to plot shapes for different types of missing values. By default, this is set to FALSE to speed up plotting. We only recommend using `shape = TRUE` for small datasets.}
}
\value{
Boxplots with overlaying data points
}
\description{
Plot observed values versus m sets of imputed values for one specified numeric variable and two factors using \pkg{ggplot2}.
}
\examples{
# create some extra missing values in factor variables "HSSEX" and "DMARETHN"
nhanes3_NA <- createNA(nhanes3, var.names = c("HSSEX", "DMARETHN"), p = 0.1)

# obtain m multiply datasets
params <- list(max_depth = 3, subsample = 0.8, nthread = 2)
imputed.data <- mixgb(data = nhanes3_NA, m = 3, xgb.params = params, nrounds = 30)

# plot the multiply imputed values for variables "BMPRECUM" versus "HSSEX" conditional on "DMARETHN"
plot_1num2fac(
  imputation.list = imputed.data, var.fac = "HSSEX", var.num = "BMPRECUM",
  con.fac = "DMARETHN", original.data = nhanes3_NA
)
}
