% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.xlsx.R
\name{write.xlsx}
\alias{write.xlsx}
\title{Write Excel File}
\usage{
write.xlsx(x, file = "Excel_Data.xlsx", col.names = TRUE, format = FALSE,
           use.zip64 = FALSE, check = TRUE)
}
\arguments{
\item{x}{a matrix, data frame or (named) list of matrices or data frames
that will be written in the Excel file.}

\item{file}{a character string naming a file with or without file extension
'.xlsx', e.g., \code{"My_Excle.xlsx"} or \code{"My_Excel"}.}

\item{col.names}{logical: if \code{TRUE}, column names are written at the top
of the Excel sheet.}

\item{format}{logical: if \code{TRUE}, column names in the Excel file are
centered and bold.}

\item{use.zip64}{logical: if \code{TRUE}, zip64 to enable support for 4GB+ Excel
files is used.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\description{
This function calls the \code{write_xlsx()} function in the \pkg{writexl} package
by Jeroen Ooms to write an Excel file (.xlsx).
}
\details{
This function supports strings, numbers, booleans, and dates.
}
\note{
The function was adapted from the \code{write_xlsx()} function in the \pkg{writexl}
package by Jeroen Ooms (2021).
}
\examples{
\dontrun{
# Example 1: Write Excel file (.xlsx)
dat <- data.frame(id = 1:5,
                  gender = c(NA, 0, 1, 1, 0),
                  age = c(16, 19, 17, NA, 16),
                  status = c(1, 2, 3, 1, 4),
                  score = c(511, 506, 497, 502, 491))

write.xlsx(dat, file = "Excel.xlsx")

# Example 2: Write Excel file with multiple sheets (.xlsx)
write.xlsx(list(cars = cars, mtcars = mtcars), file = "Excel_Sheets.xlsx")
}
}
\references{
Jeroen O. (2021). \emph{writexl: Export Data Frames to Excel 'xlsx' Format}.
R package version 1.4.0. https://CRAN.R-project.org/package=writexl
}
\seealso{
\code{\link{read.xlsx}}, \code{\link{write.sav}}, \code{\link{write.dta}},
\code{\link{write.mplus}}
}
\author{
Jeroen Ooms
}
