% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.na.coverage.R
\name{print.na.coverage}
\alias{print.na.coverage}
\title{Print na.coverage}
\usage{
\method{print}{na.coverage}(x, tri = x$args$tri, digits = x$args$digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{na.coverage} object.}

\item{tri}{a character string or character vector indicating which triangular of the matrix to show on the console,
i.e., \code{both} for upper and lower triangular, \code{lower} (default) for the lower triangular,
and \code{upper} for the upper triangular.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying proportions.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{na.coverage} object
}
\examples{
#--------------------------------------
# Matrix
mat <- matrix(c(1, NA, NA, 6, 3,
                7, NA, 8, 9, NA,
                2, NA, 3, NA, 5), ncol = 3)

# Create missing data indicator matrix R
mat.coverage <- na.coverage(mat, output = FALSE)

# Print na.coverage object with 5 digits
print(mat.coverage, digits = 5)

#--------------------------------------
# Data frame
dat <- data.frame(x = c(1, NA, NA, 6, 3),
                  y = c(7, NA, 8, 9, NA),
                  z = c(2, NA, 3, NA, 5))

# Create missing data indicator matrix R
na.coverage(dat)

# Create missing data indicator matrix R
dat.coverage <- na.coverage(mat, output = FALSE)

# Print na.coverage object with 5 digits
print(dat.coverage, digits = 5)
}
\seealso{
\code{\link{na.coverage}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
