% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cor.matrix.R
\name{print.cor.matrix}
\alias{print.cor.matrix}
\title{Print cor.matrix object}
\usage{
\method{print}{cor.matrix}(x, print = x$args$print, tri = x$args$tri,
      digits = x$args$digits, pval.digits = x$args$pval.digits,
      check = TRUE, ...)
}
\arguments{
\item{x}{\code{cor.matrix} object.}

\item{print}{a character string or character vector indicating which additional results to show,
i.e. \code{"all"}, for all additional results: \code{"n"} for the sample sizes,
\code{"p"}, and for \emph{p}-values.}

\item{tri}{a character string indicating which triangular of the matrix to show on the console,
i.e., \code{both} for upper and lower triangular, \code{lower} for the lower triangular,
and \code{upper} for the upper triangular.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
correlation coefficients.}

\item{pval.digits}{an integer indicating the number of decimal places to be used for displaying \emph{p}-values.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{cor.matrix} object
}
\examples{
dat <- data.frame(group = c("a", "a", "a", "a", "a",
                            "b", "b", "b", "b", "b"),
                  x = c(5, NA, 6, 4, 6, 7, 9, 5, 8, 7),
                  y = c(3, 3, 5, 6, 7, 4, 7, NA, NA, 8),
                  z = c(1, 3, 1, NA, 2, 4, 6, 5, 9, 6))

# Pearson product-moment correlation coefficient matrix using pairwise deletion
dat.cor <- cor.matrix(dat[, c("x", "y", "z")], output = FALSE)

# Print cor.matrix object with 3 digits for correlation coefficients
# and 4 digits for significance values
print(dat.cor, print = "all", digits = 3, pval.digits = 4)
}
\seealso{
\code{\link{cor.matrix}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
