% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_hurdle.R
\name{prior_hurdle}
\alias{prior_hurdle}
\title{An internal function to change the hyperprior parameters in the hurdle model provided by the user depending on the type of
structural value mechanism and outcome distributions assumed}
\usage{
prior_hurdle(
  type,
  dist_e,
  dist_c,
  pe_fixed,
  pc_fixed,
  ze_fixed,
  zc_fixed,
  model_e_random,
  model_c_random,
  model_se_random,
  model_sc_random,
  pe_random,
  pc_random,
  ze_random,
  zc_random,
  se,
  sc
)
}
\arguments{
\item{type}{Type of structural value mechanism assumed. Choices are Structural Completely At Random (SCAR),
and Structural At Random (SAR). For a complete list of all available hyper parameters 
and types of models see the manual.}

\item{dist_e}{distribution assumed for the effects. Current available chocies are: Normal ('norm'), Beta ('beta'), Gamma ('gamma'), Exponential ('exp'),
Weibull ('weibull'), Logistic ('logis'), Poisson ('pois'), Negative Binomial ('nbinom') or Bernoulli ('bern')}

\item{dist_c}{distribution assumed for the costs. Current available chocies are: Normal ('norm'), Gamma ('gamma') or LogNormal ('lnorm')}

\item{pe_fixed}{Number of fixed effects for the effectiveness model}

\item{pc_fixed}{Number of fixed effects for the cost model}

\item{ze_fixed}{Number of fixed effects or the structural indicators model for the effectiveness}

\item{zc_fixed}{Number of fixed effects or the structural indicators model for the costs}

\item{model_e_random}{Random effects formula for the effectiveness model}

\item{model_c_random}{Random effects formula for the costs model}

\item{model_se_random}{Random effects formula for the structural indicators model for the effectiveness}

\item{model_sc_random}{Random effects formula for the structural indicators model for the costs}

\item{pe_random}{Number of random effects for the effectiveness model}

\item{pc_random}{Number of random effects for the cost model}

\item{ze_random}{Number of random effects or the structural indicators model for the effectiveness}

\item{zc_random}{Number of random effects or the structural indicators model for the costs}

\item{se}{Structural value for the effectiveness}

\item{sc}{Structural value for the costs}
}
\description{
This function modifies default hyper prior parameter values in the type of hurdle model selected according 
to the type of structural value mechanism and distributions for the outcomes assumed.
}
\examples{
#Internal function only
#no examples
#
#
}
\keyword{distributions}
\keyword{hurdle}
\keyword{models}
\keyword{priors}
