% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map}
\alias{map}
\alias{map.missSOM}
\title{Map data to a supervised or unsupervised SOM}
\usage{
map(x, ...)

\method{map}{missSOM}(x, newdata, maxNA.fraction = x$maxNA.fraction, ...)
}
\arguments{
\item{x}{an object of class \code{missSOM}.}

\item{...}{Currently ignored.}

\item{newdata}{a \code{matrix} or \code{data.frame}, equal to the \code{data} argument of the \code{imputeSOM} function.}

\item{maxNA.fraction}{parameters that usually will be taken from the \code{x} object, but can be supplied by the user as well. 
Note that it is not possible to change distance functions from the ones used in training the map. See \code{\link{imputeSOM}} 
for more information.}
}
\value{
A list with elements 
\item{unit.classif}{a vector of units that are closest to the objects in the data.}
\item{dists}{distances of the objects to the closest units. Distance measures are the same ones used in training the map.}
}
\description{
Map a data onto a trained SOM.
}
\examples{
data(wines)
set.seed(7)

training <- sample(nrow(wines), 150)
Xtraining <- scale(wines[training, ])
somnet <- imputeSOM(Xtraining, somgrid(5, 5, "hexagonal"))

map(somnet, scale(wines[-training, ], 
                  center=attr(Xtraining, "scaled:center"), 
                  scale=attr(Xtraining, "scaled:scale")))

}
\seealso{
\code{\link{imputeSOM}}
}
