% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_expected_values.R
\name{impute_expected_values}
\alias{impute_expected_values}
\title{Impute expected values}
\usage{
impute_expected_values(
  ds,
  mu,
  S,
  stochastic = FALSE,
  M = is.na(ds),
  verbose = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{mu}{Vector of means for the variables.}

\item{S}{Covariance matrix of the variables.}

\item{stochastic}{Logical, should residuals be added to the expected values.}

\item{M}{Missing data indicator matrix.}

\item{verbose}{Should messages be given for special cases (see details)?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Impute the missing values with expected values given the observed values and
estimated parameters assuming a multivariate normal distribution
}
\details{
Normally, this function is called by other imputation function and should not
be called directly. The function imputes the missing values assuming a
multivariate normal distribution. This is equivalent to imputing the least
squares estimate of the missing values in some kind of way.

If no values is observed in a row or a relevant submatrix of the
covariance matrix (\code{S_22}) is not invertible, the missing values are imputed
with (parts of) \code{mu} (plus a residuum, if \code{stochastich = TRUE}). If
\code{verbose = TRUE}, these cases will be listed in a message. Otherwise, they
will be imputed silently.
}
