% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_one_group.R
\name{delete_MAR_one_group}
\alias{delete_MAR_one_group}
\title{Create MAR values by deleting values in one of two groups}
\usage{
delete_MAR_one_group(
  ds,
  p,
  miss_cols,
  ctrl_cols,
  cutoff_fun = median,
  prop = 0.5,
  use_lpSolve = TRUE,
  ordered_as_unordered = FALSE,
  stochastic = FALSE,
  ...
)
}
\arguments{
\item{ds}{a data frame or matrix in which missing values will be created}

\item{p}{a numeric vector with length one or equal to length \code{miss_cols};
the probability that a value is missing}

\item{miss_cols}{a vector of column names or indices of columns in which
missing values will be created}

\item{ctrl_cols}{a vector of column names or indices of columns, which
controls the creation of missing values in \code{miss_cols}. Must be of the
same length as \code{miss_cols}.}

\item{cutoff_fun}{function that calculates the cutoff values in the
\code{ctrl_cols}}

\item{prop}{numeric of length one; (minimum) proportion of rows in group 1}

\item{use_lpSolve}{logical; should lpSolve be used for the determination of
groups, if \code{ctrl_cols[i]} is an unordered factor}

\item{ordered_as_unordered}{logical; should ordered factors be treated as
unordered factors}

\item{stochastic}{logical; see details}

\item{...}{further arguments passed to \code{cutoff_fun}}
}
\value{
An object of the same class as \code{ds} with missing values
}
\description{
Create missing at random (MAR) values by deleting values in one of two
groups in a data frame or a matrix
}
\details{
This function creates missing at random (MAR) values in the columns
specified by the argument \code{miss_cols}.
The probability for missing values is controlled by \code{p}.
If \code{p} is a single number, then the overall probability for a value to
be missing will be \code{p} in all columns of \code{miss_cols}.
(Internally \code{p} will be replicated to a vector of the same length as
\code{miss_cols}.
So, all \code{p[i]} in the following sections will be equal to the given
single number \code{p}.)
Otherwise, \code{p} must be of the same length as \code{miss_cols}.
In this case, the overall probability for a value to be missing will be
\code{p[i]} in the column \code{miss_cols[i]}.
The position of the missing values in \code{miss_cols[i]} is controlled by
\code{ctrl_cols[i]}.
The following procedure is applied for each pair of \code{ctrl_cols[i]} and
\code{miss_cols[i]} to determine the positions of missing values:

At first, the rows of \code{ds} are divided into two groups.
Therefore, the \code{cutoff_fun} calculates a cutoff value for
\code{ctrl_cols[i]} (via \code{cutoff_fun(ds[, ctrl_cols[i]], ...)}.
The group 1 consists of the rows, whose values in
\code{ctrl_cols[i]} are below the calculated cutoff value.
If the so defined group 1 is empty, the rows that are equal to the
cutoff value will be added to this group (otherwise, these rows will
belong to group 2).
The group 2 consists of the remaining rows, which are not part of group 1.
Now one of these two groups is chosen randomly.
In the chosen group, values are deleted in \code{miss_cols[i]}.
In the other group, no missing values will be created in \code{miss_cols[i]}.

If \code{stochastic = FALSE} (the default), then \code{floor(nrow(ds) * p[i])}
or \code{ceiling(nrow(ds) * p[i])} values will be set \code{NA} in
column \code{miss_cols[i]} (depending on the grouping).
If \code{stochastic = TRUE}, each value in the group with missing values
will have a probability to be missing, to meet a proportion of
\code{p[i]} of missing values in \code{miss_cols[i]} in expectation.
The effect of \code{stochastic} is further discussed in
\code{\link{delete_MCAR}}.
}
\section{Treatment of factors}{


If \code{ds[, ctrl_cols[i]]} is an unordered factor, then the concept of a
cutoff value is not meaningful and cannot be applied.
Instead, a combinations of the levels of the unordered factor is searched that
\itemize{
\item{guarantees at least a proportion of \code{prop} rows are in group 1}
\item{minimize the difference between \code{prop} and the proportion of
rows in group 1.}
}
This can be seen as a binary search problem, which is solved by the solver
from the package \code{lpSolve}, if \code{use_lpSolve = TRUE}.
If \code{use_lpSolve = FALSE}, a very simple heuristic is applied.
The heuristic only guarantees that at least a proportion of \code{prop} rows
are in group 1.
The choice \code{use_lpSolve = FALSE} is not recommend and should only be
considered, if the solver of lpSolve fails.

If \code{ordered_as_unordered = TRUE}, then ordered factors will be treated
like unordered factors and the same binary search problem will be solved for
both types of factors.
If \code{ordered_as_unordered = FALSE} (the default), then ordered factors
will be grouped via \code{cutoff_fun} as described in Details.
}

\examples{
ds <- data.frame(X = 1:20, Y = 101:120)
delete_MAR_one_group(ds, 0.2, "X", "Y")
}
\references{
Santos, M. S., Pereira, R. C., Costa, A. F., Soares, J. P.,
  Santos, J., & Abreu, P. H. (2019). Generating Synthetic Missing Data: A
  Review by Missing Mechanism. \emph{IEEE Access}, 7, 11651-11667
}
\seealso{
\code{\link{delete_MNAR_one_group}}

Other functions to create MAR: 
\code{\link{delete_MAR_1_to_x}()},
\code{\link{delete_MAR_censoring}()},
\code{\link{delete_MAR_rank}()}
}
\concept{functions to create MAR}
