% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{gtrack.import}
\alias{gtrack.import}
\title{Creates a track from WIG / BigWig / BedGraph / tab-delimited file}
\usage{
gtrack.import(
  track = NULL,
  description = NULL,
  file = NULL,
  binsize = NULL,
  defval = NaN
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{file}{file path}

\item{binsize}{bin size of the newly created 'Dense' track or '0' for a
'Sparse' track}

\item{defval}{default track value}
}
\value{
None.
}
\description{
Creates a track from WIG / BigWig / BedGraph / tab-delimited file
}
\details{
This function creates a track from WIG / BigWig / BedGraph / tab-delimited
file.  One can learn about the format of the tab-delimited file by running
'gextract' function on a 1D track with a 'file' parameter set to the name of
the file. Zipped files are supported (file name must have '.gz' or '.zip'
suffix).

If 'binsize' is 0 the resulted track is created in 'Sparse' format.
Otherwise the 'Dense' format is chosen with a bin size equal to 'binsize'.
The values that were not defined in input file file are substituted by
'defval' value.

'description' is added as a track attribute.
}
\seealso{
\code{\link{gtrack.import_set}}, \code{\link{gtrack.rm}},
\code{\link{gtrack.info}}, \code{\link{gdir.create}}, \code{\link{gextract}}
}
\keyword{~bedgraph}
\keyword{~bigwig}
\keyword{~track}
\keyword{~wig}
