% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gapply}
\alias{as.data.frame.gapply}
\alias{as.data.table.gapply}
\alias{gapply}
\alias{levels.gapply}
\title{Apply a Function by a Grid on a List}
\usage{
gapply(d, by, fun, ..., drop = TRUE, cores = 1)

\method{levels}{gapply}(x)

\method{as.data.frame}{gapply}(x, ...)

\method{as.data.table}{gapply}(x, keyv = NULL, ...)
}
\arguments{
\item{d}{A data.frame or data.table object.}

\item{by}{A character vector with colnames for the grid to subset.}

\item{fun}{A function to apply on \code{d}.}

\item{...}{Additional arguments to \code{fun} or to \code{as.data.frame} method.}

\item{drop}{Drop grid columns for \code{fun}.}

\item{cores}{Number of multicores as \code{mc.cores} in \code{mclapply}.}

\item{x}{Object of class \code{gapply}.}

\item{keyv}{Character vector for \code{data.table} keys.}
}
\description{
\code{gapply} applies a function on a \code{data.frame} by using named list
 entries as grid. Support of multicore processing via \code{mclapply}.\cr
\code{levels} is a method to retrieve the grid of a \code{gapply} object.\cr
\code{as.data.frame} is a simplified rbind version which adds the grid
to the output.
}
\details{
The output of \code{gapply} is a list inheriting from the S3 class gapply which stores
the grid of the original data. Support for subsetting grid entries is not yet
supported. The function \code{fun} receives the subset of the data frame as
first argument.
}
\examples{
#

f <- function (x) c(conc.diff = diff(range(x$conc)), uptake.sum=sum(x$uptake))
d <- gapply(CO2, c('Type', 'Treatment'), f)
d
levels(d)
as.data.frame(d)

#
}
\author{
Sven E. Templer (\email{sven.templer@gmail.com})
}
\seealso{
\link{mclapply}, \link[data.table]{setkeyv}
}

