% Generated by roxygen2 (4.0.1): do not edit by hand
\name{enpaire}
\alias{enpaire}
\alias{enpaire.default}
\alias{enpaire.dist}
\alias{enpaire.matrix}
\title{Create a Pairwise List from a Matrix}
\usage{
enpaire(x, ...)

\method{enpaire}{default}(x, ...)

\method{enpaire}{dist}(x, upper = T, lower = T, ...)

\method{enpaire}{matrix}(x, upper = T, lower = T, ...)
}
\arguments{
\item{x}{Object of class \code{matrix}.}

\item{upper}{Logical, return values from upper triangle.}

\item{lower}{Logical, return values from lower triangle.}

\item{...}{Arguments passed to methods.}
}
\value{
Returns a \code{data.frame}. The first and second column represent the
dimension names for a value in \code{x}. The following columns contain
the values for the upper or lower triangle.
}
\description{
Transform a \code{matrix} or \code{dist} object to a pairwise list.
}
\examples{
#

m <- matrix(letters[1:9], 3, 3, dimnames = list(1:3,1:3))
enpaire(m)
enpaire(m, lower = FALSE)

#
}
\author{
Sven E. Templer (\email{sven.templer@gmail.com})
}
\seealso{
\link{squarematrix}
}
\keyword{matrix}
\keyword{pairwise}

