% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplot.R
\name{scatterplot}
\alias{scatterplot}
\title{Scatterplot Matrices}
\usage{
scatterplot(dat, type = c("jitter", "size", "count", "sun", "identity"),
  barplot = TRUE, curves = TRUE)
}
\arguments{
\item{dat}{a dat frame}

\item{type}{type of plot, i.e., 'jitter', 'size', 'count', 'sun', and 'identity'}

\item{barplot}{logical: if \code{TRUE} barplots are shown in the diagonals.}

\item{curves}{logical: if \code{TRUE} lowess smoothing curves are added in the upper diagonal.}
}
\description{
This function produces a scatterplot matrix for integer data
}
\examples{
dat <- round(sim.cor(200, rho = 0.7))

# Scatterplot matrix: jitter
scatterplot(dat)

# Scatterplot matrix: size
scatterplot(dat, type = "size")

# Scatterplot matrix: count
scatterplot(dat, type = "count")

# Scatterplot matrix: sun
scatterplot(dat, type = "sun")
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.
}
\seealso{
\code{\link{test.cor}}, \code{\link{seqtest.cor}}
}

