% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{require_daemons}
\alias{require_daemons}
\title{Require Daemons}
\usage{
require_daemons(call = environment(), .compute = NULL)
}
\arguments{
\item{call}{(only used if the \CRANpkg{cli} package is installed) the
execution environment of a currently running function, e.g.
\code{environment()}. The function will be mentioned in error messages as the
source of the error.}

\item{.compute}{[default NULL] character value for the compute profile to
query, or NULL to query the 'default' profile.

\strong{or} a 'miraiCluster' to obtain its status.}
}
\value{
Logical \code{TRUE}, or else errors.
}
\description{
Returns TRUE only if daemons are set, otherwise produces an informative
error for the user to set daemons, with a clickable function link if the
\CRANpkg{cli} package is available.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
daemons(1)
require_daemons()
daemons(0)
\dontshow{\}) # examplesIf}
}
