% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{unresolved}
\alias{unresolved}
\title{Query if a Mirai is Unresolved}
\usage{
unresolved(aio)
}
\arguments{
\item{aio}{A 'mirai' or mirai value stored in \code{$data} (mirai are also
aio objects).}
}
\value{
Logical TRUE or FALSE.
}
\description{
Query whether a mirai or mirai value remains unresolved. Unlike
    \code{\link{call_mirai}}, this function does not wait for completion.
}
\details{
Returns TRUE for unresolved mirai or mirai values, FALSE otherwise.

    Suitable for use in control flow statements such as \code{while} or \code{if}.

    Note: querying resolution may cause a previously unresolved mirai to resolve.
}
\examples{
if (interactive()) {
# Only run examples in interactive R sessions

m <- mirai(Sys.sleep(0.1))
unresolved(m)
Sys.sleep(0.5)
unresolved(m)

}

}
