% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{mm2r}
\alias{mm2r}
\title{Convert FreeMind mind map code into .R code}
\usage{
mm2r(from = NA, r_seclabel = " --------", r_chunkheading = FALSE)
}
\arguments{
\item{from}{Character. The source text of the (R) Markdown syntax text, the R code, the FreeMind mind map code, or the path to the directory.}

\item{r_seclabel}{Character. The ending characters indicating sections in R Markdown.}

\item{r_chunkheading}{Logical. Whether process the chunk label as headings.}
}
\value{
Character, R code.
}
\description{
Convert FreeMind mind map code into .R code
}
\examples{
input <- system.file("examples/mindr-mm.mm", package = "mindr")
input_txt <- readLines(input, encoding = "UTF-8")
output_txt <- mm2r(input_txt)
output <- tempfile(pattern = "file", tmpdir = tempdir(), fileext = ".R")
writeLines(output_txt, output, useBytes = TRUE)
# file.show(input) # Open the input file file.show(output) # Open the output
# file
message("Input:  ", input, "\nOutput: ", output)
# file.remove(output) # remove the output file
}
