% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read}
\alias{read}
\alias{read_edgelist}
\alias{read_ucinet}
\alias{write_ucinet}
\title{Reading from/writing to external formats}
\usage{
read_edgelist(file)

read_ucinet(header_file)

write_ucinet(
  object,
  filename = deparse(substitute(object)),
  name = deparse(substitute(object))
)
}
\arguments{
\item{file, header_file}{A character string giving the path to the header
(.##h) file. If the function is called without a header_file specified,
an OS-specific file picker is opened to help users select it.}

\item{object}{A migraph-consistent object to be exported.}

\item{filename}{UCINET filename (without ## extension).
By default the files will have the same name as the object
and be saved to the working directory.}

\item{name}{name of matrix to be known in UCINET.
By default the name will be the same as the object.}
}
\value{
By default, \code{\link[=read_ucinet]{read_ucinet()}} and \code{\link[=read_edgelist]{read_edgelist()}}
will import into an igraph format,
but can be easily coerced from there into other formats.

A pair of UCINET files in V6404 file format (.##h, .##h)
}
\description{
These functions import from and export to UCINET network files.
}
\details{
These functions only work with relatively recent UCINET
file formats, e.g. type 6406 files.
To import earlier UCINET file types, you will need to update them first.

To import multiple matrices packed into a single UCINET file,
you will need to unpack them and convert them one by one.
}
\examples{
\dontrun{
# import Roethlisberger & Dickson's horseplay game data set:
horseplay <- read_ucinet("WIRING-RDGAM.##h")
}
\dontrun{
# export it again to UCINET under a different name:
write.ucinet(horseplay,"R&D-horseplay")
}
}
\seealso{
\link{convert}
}
\author{
Christian Steglich, 18 June 2015
}
