% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_diversity.R
\name{diversity}
\alias{diversity}
\alias{graph_blau_index}
\alias{graph_ei_index}
\alias{graph_assortativity}
\title{Measures of network diversity}
\usage{
graph_blau_index(object, attribute, clusters = NULL)

graph_ei_index(object, attribute)

graph_assortativity(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{attribute}{The name of a vertex attribute to measure the diversity of.}

\item{clusters}{A nodal cluster membership vector or name of a vertex attribute.}
}
\description{
These functions offer ways to summarise the heterogeneity of an attribute
across a network, within groups of a network, or the distribution of ties
across this attribute.
}
\section{Functions}{
\itemize{
\item \code{graph_blau_index}: Calculates the heterogeneity of ties across a network or
within clusters by node attributes

\item \code{graph_ei_index}: Calculates the embeddedness of a node within the group
of nodes of the same attribute

\item \code{graph_assortativity}: Calculates the degree assortativity in a graph
}}

\examples{
marvel_friends <- to_unsigned(ison_marvel_relationships, "positive")
graph_blau_index(marvel_friends, "Gender")
graph_blau_index(marvel_friends, "Attractive")
graph_blau_index(marvel_friends, "Gender", "Rich")
graph_ei_index(marvel_friends, "Gender")
graph_ei_index(marvel_friends, "Attractive")
graph_assortativity(mpn_elite_mex)
}
\seealso{
Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{features}},
\code{\link{holes}}
}
\concept{measures}
