% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mo.R
\name{domhv_improvement}
\alias{domhv_improvement}
\title{Calculate Hypervolume Improvement}
\usage{
domhv_improvement(fitnesses, baseline = NULL, nadir = 0)
}
\arguments{
\item{fitnesses}{(\verb{numeric matrix})\cr
fitness matrix, with one row per individual and one column per objective}

\item{baseline}{(\code{matrix} | \code{NULL})\cr
Fitness-matrix with one column per objective, giving a population over which the hypervolume improvement should be calculated.
If \code{NULL}, the hypervolume of each individual in \code{fitnesses} is calculated.}

\item{nadir}{(\code{numeric})\cr
Lowest fitness point up to which to calculate dominated hypervolume. May be a scalar, in which case
it is used for all dimensions, or a vector, in which case its length must match the number of dimensions.
Default 0.}
}
\value{
\code{numeric}: The vector of dominated hypervolume contributions for each individual in \code{fitnesses}.
}
\description{
Takes a \code{matrix} of fitness values and calculates the hypervolume improvement of individuals in that \code{matrix}, one by one,
over the \code{baseline} individuals.

The hypervolume improvement for each point is the measure of all points that have fitnesses that are
\itemize{
\item greater than the respective value in \code{nadir} in all dimensions, and
\item smaller than the respective value in the given point in all dimensions, and
\item greater than all points in \code{baseline} in at least one dimension.
}

Individuals in \code{fitnesses} are considered independently of each other. A possible speedup is achieved because
\code{baseline} individuals only need to be pre-filtered once.
}
\examples{
(fitnesses = matrix(c(1, 5, 2, 3, 0, 3, 1, 0, 10, 8), ncol = 2))

# to see the fitness matrix, use:
## plot(fitnesses, pch = as.character(1:5))

domhv_improvement(fitnesses)

domhv_improvement(fitnesses, fitnesses[1, , drop = FALSE])
}
