% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamSetShadow.R
\name{ParamSetShadow}
\alias{ParamSetShadow}
\title{ParamSetShadow}
\description{
Wraps another \code{\link[paradox:ParamSet]{ParamSet}} and shadows out a subset of its \code{\link[paradox:Param]{Param}}s.
The original \code{\link[paradox:ParamSet]{ParamSet}} can still be accessed through the \verb{$origin} field;
otherwise, the \code{ParamSetShadow} behaves like a \code{\link[paradox:ParamSet]{ParamSet}} where the shadowed
\code{\link[paradox:Param]{Param}}s are not present.
}
\examples{
p1 = ps(x = p_dbl(0, 1), y = p_lgl())
p1$values = list(x = 0.5, y = TRUE)
print(p1)

p2 = ParamSetShadow$new(p1, "x")
print(p2$values)

p2$values$y = FALSE
print(p2)

print(p2$origin$values)
}
\section{Super class}{
\code{\link[paradox:ParamSet]{paradox::ParamSet}} -> \code{ParamSetShadow}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{params}}{(named \code{list} of \code{\link[paradox:Param]{Param}})
List of \code{\link[paradox:Param]{Param}} that are members of the wrapped \code{\link[paradox:ParamSet]{ParamSet}} with the
shadowed \code{\link[paradox:Param]{Param}}s removed.}

\item{\code{params_unid}}{(named \code{list} of \code{\link[paradox:Param]{Param}})
List of \code{\link[paradox:Param]{Param}} that are members of the wrapped \code{\link[paradox:ParamSet]{ParamSet}} with the
shadowed \code{\link[paradox:Param]{Param}}s removed. This is a field mostly for internal usage that has the
\verb{$id}s set to invalid values but avoids cloning overhead.}

\item{\code{deps}}{(\code{\link[data.table:data.table]{data.table}})\cr
Table of dependencies, as in \code{\link[paradox:ParamSet]{ParamSet}}. The dependencies that are related to shadowed
parameters are not exposed. This \code{\link[data.table:data.table]{data.table}} should be seen as read-only and not
modified in-place; instead, the \verb{$origin}'s \verb{$deps} should be modified.}

\item{\code{values}}{(named \code{list})\cr
List of values, as in \code{\link[paradox:ParamSet]{ParamSet}}, with the shadowed values removed.}

\item{\code{set_id}}{(\code{\link[data.table:data.table]{data.table}})\cr
Id of the wrapped \code{\link[paradox:ParamSet]{ParamSet}}. Changing this value will also change the wrapped \code{\link[paradox:ParamSet]{ParamSet}}'s \verb{$set_id} accordingly.}

\item{\code{origin}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
\code{\link[paradox:ParamSet]{ParamSet}} being wrapped. This object can be modified by reference to influence the \code{ParamSetShadow} object itself.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParamSetShadow-new}{\code{ParamSetShadow$new()}}
\item \href{#method-ParamSetShadow-add}{\code{ParamSetShadow$add()}}
\item \href{#method-ParamSetShadow-subset}{\code{ParamSetShadow$subset()}}
\item \href{#method-ParamSetShadow-add_dep}{\code{ParamSetShadow$add_dep()}}
\item \href{#method-ParamSetShadow-clone}{\code{ParamSetShadow$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="assert"><a href='../../paradox/html/ParamSet.html#method-ParamSet-assert'><code>paradox::ParamSet$assert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="assert_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-assert_dt'><code>paradox::ParamSet$assert_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="check"><a href='../../paradox/html/ParamSet.html#method-ParamSet-check'><code>paradox::ParamSet$check()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="check_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-check_dt'><code>paradox::ParamSet$check_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="format"><a href='../../paradox/html/ParamSet.html#method-ParamSet-format'><code>paradox::ParamSet$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="get_values"><a href='../../paradox/html/ParamSet.html#method-ParamSet-get_values'><code>paradox::ParamSet$get_values()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="ids"><a href='../../paradox/html/ParamSet.html#method-ParamSet-ids'><code>paradox::ParamSet$ids()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="print"><a href='../../paradox/html/ParamSet.html#method-ParamSet-print'><code>paradox::ParamSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="search_space"><a href='../../paradox/html/ParamSet.html#method-ParamSet-search_space'><code>paradox::ParamSet$search_space()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="set_values"><a href='../../paradox/html/ParamSet.html#method-ParamSet-set_values'><code>paradox::ParamSet$set_values()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="test"><a href='../../paradox/html/ParamSet.html#method-ParamSet-test'><code>paradox::ParamSet$test()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="test_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-test_dt'><code>paradox::ParamSet$test_dt()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetShadow-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetShadow-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{ParamSetShadow} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetShadow$new(set, shadowed)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
\code{\link[paradox:ParamSet]{ParamSet}} to wrap.}

\item{\code{shadowed}}{(\code{character})\cr
Ids of \code{\link[paradox:Param]{Param}}s to shadow from \code{sets}, must be a subset of \code{set$ids()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetShadow-add"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetShadow-add}{}}}
\subsection{Method \code{add()}}{
Adds a single param or another set to this set, all params are cloned.

This calls the underlying \code{\link[paradox:ParamSet]{ParamSet}}'s \verb{$add()} function.

\code{\link[paradox:Param]{Param}} with ids that also occur in the underlying  \code{\link[paradox:ParamSet]{ParamSet}}
but are shadowed can \emph{not} be added and instead will result in an error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetShadow$add(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{(\code{\link[paradox:Param]{Param}} | \code{\link[paradox:ParamSet]{ParamSet}})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetShadow-subset"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetShadow-subset}{}}}
\subsection{Method \code{subset()}}{
Reduces the parameters to the ones of passed ids.

This calls the underlying \code{\link[paradox:ParamSet]{ParamSet}}'s \verb{$subset()} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetShadow$subset(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetShadow-add_dep"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetShadow-add_dep}{}}}
\subsection{Method \code{add_dep()}}{
Adds a dependency to the unterlying \code{\link[paradox:ParamSet]{ParamSet}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetShadow$add_dep(id, on, cond)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})}

\item{\code{on}}{(\code{character(1)})}

\item{\code{cond}}{(\code{\link[paradox:Condition]{Condition}})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetShadow-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetShadow-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetShadow$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
