% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorFixedProjections.R
\name{scalarizer_linear}
\alias{scalarizer_linear}
\title{Linear Scalarizer}
\usage{
scalarizer_linear()
}
\value{
a \code{\link{Scalarizer}} object.
}
\description{
Constructs a linear \code{\link{Scalarizer}}, which performs linear scalarization for \code{\link{ScalorFixedProjection}}.
}
\examples{
# fitnesses: three rows (i.e. thee indivs) with two objective values each
fitnesses <- matrix(0:5, ncol = 2)

# weights: contains one matrix for each row of 'fitnesses' (i.e. each indiv)
# which get multiplied with their respective row.
weights <- list(
 matrix(c(1, 0, 0, 1), ncol = 2),
 matrix(c(1, 2, 0, 0), ncol = 2),
 matrix(c(0, 1, 0, 1), ncol = 2)
)

sc <- scalarizer_linear()

# The resulting row-vectors are the different scalarizations according to the
# columns in the 'weights' matrices.
sc(fitnesses, weights)
}
\seealso{
Other Scalarizers: 
\code{\link{Scalarizer}},
\code{\link{scalarizer_chebyshev}()}
}
\concept{Scalarizers}
