% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcpp_hello_world.R
\name{RNGStream}
\alias{RNGStream}
\alias{RNGStream-class}
\alias{with.RNGStream}
\title{S3 class to work with RngStream objects}
\usage{
RNGStream(nextStream = TRUE, iseed = NULL)

\method{with}{RNGStream}(data, expr, ...)
}
\arguments{
\item{nextStream}{whether to move to the next stream (default=TRUE)}

\item{iseed}{set seed after changing RNG (otherwise keep the current seed)}

\item{data}{object of type RNGStream}

\item{expr}{expression using the RNGStream}

\item{...}{other arguments passed to eval()}
}
\value{
list of class \code{RNGStream} with components:
\describe{
\item{resetRNGkind}{function to reset to the previous RNG and seed}
\item{seed}{function to return the current seed}
item{open}{function to use the current seed}
item{close}{function to make the current seed equal to .Random.seed}
item{resetStream}{function to move back to start of stream}
item{resetSubStream}{function to move back to start of sub-stream}
item{nextSubStream}{function to move to next sub-stream}
item{nextStream}{function to move to next stream}
}

the value from the expression
}
\description{
S3 class to work with RngStream objects

Use RNGStream as an old class

With method for RNGStream S3 class
}
\examples{
## set up one stream
s1 <- RNGStream()
s1$open()
rnorm(1)
s1$nextSubStream()
rnorm(1)
## reset the stream
s1$resetStream()
rnorm(2)
s1$nextSubStream()
rnorm(2)

## now do with two streams
s1$resetStream()
s2 <- RNGStream()
with(s1,rnorm(1))
with(s2,rnorm(1))
s1$nextSubStream()
with(s1,rnorm(1))
## now reset the streams and take two samples each time
s1$resetStream()
s2$resetStream()
with(s1,rnorm(2))
with(s2,rnorm(2))
s1$nextSubStream()
with(s1,rnorm(2))
}
