% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerlaw.R
\name{heaps}
\alias{heaps}
\title{Heaps law estimate}
\usage{
heaps(pan.matrix, n.perm = 100)
}
\arguments{
\item{pan.matrix}{A \code{Panmat} object, see \code{\link{panMatrix}} for details.}

\item{n.perm}{The number of random permutations of genome ordering.}
}
\value{
A vector of two estimated parameters: The \samp{Intercept} and the decay parameter \samp{alpha}.
If \samp{alpha<1.0} the pan-genome is open, if \samp{alpha>1.0} it is closed.
}
\description{
Estimating if a pan-genome is open or closed based on a Heaps law model.
}
\details{
An open pan-genome means there will always be new gene clusters observed as long as new genomes
are being sequenced. This may sound controversial, but in a pragmatic view, an open pan-genome indicates
that the number of new gene clusters to be observed in future genomes is \sQuote{large} (but not literally
infinite). Opposite, a closed pan-genome indicates we are approaching the end of new gene clusters. 

This function is based on a Heaps law approach suggested by Tettelin et al (2008). The Heaps law model
is fitted to the number of new gene clusters observed when genomes are ordered in a random way. The model
has two parameters, an intercept and a decay parameter called \samp{alpha}. If \samp{alpha>1.0} the
pan-genome is closed, if \samp{alpha<1.0} it is open.

The number of permutations, \samp{n.perm}, should be as large as possible, limited by computation time.
The default value of 100 is certainly a minimum.

Word of caution: The Heaps law assumes independent sampling. If some of the genomes in the data set
form distinct sub-groups in the population, this may affect the results of this analysis severely.
}
\examples{
# Loading a Panmat object in the micropan package 
data(list="Mpneumoniae.blast.panmat",package="micropan")

# Estimating population openness
h.est <- heaps(Mpneumoniae.blast.panmat,n.perm=500)
if(h.est[2]>1){
  cat("Population is closed with alpha =",h.est[2], "\\n")
} else {
  cat("Population is open with alpha =",h.est[2], "\\n")
}

}
\references{
Tettelin, H., Riley, D., Cattuto, C., Medini, D. (2008). Comparative genomics: the
bacterial pan-genome. Current Opinions in Microbiology, 12:472-477.
}
\seealso{
\code{\link{binomixEstimate}}, \code{\link{chao}}, \code{\link{rarefaction}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
